/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvas;
import acm.graphics.GCompound;
import acm.graphics.GContainer;
import acm.graphics.GDimension;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;

public abstract class GObject
implements Cloneable {
    private GContainer myParent;
    private Color color;
    private double xc;
    private double yc;
    private boolean isVisible = true;
    private boolean mouseListenersEnabled = false;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private ActionListener actionListener;

    protected GObject() {
    }

    public abstract void paint(Graphics var1);

    public abstract GRectangle getBounds();

    public void setLocation(double d, double d2) {
        this.xc = d;
        this.yc = d2;
        this.repaint();
    }

    public final void setLocation(GPoint gPoint) {
        this.setLocation(gPoint.getX(), gPoint.getY());
    }

    public GPoint getLocation() {
        return new GPoint(this.xc, this.yc);
    }

    public double getX() {
        return this.xc;
    }

    public double getY() {
        return this.yc;
    }

    public void move(double d, double d2) {
        this.setLocation(this.xc + d, this.yc + d2);
    }

    public final void movePolar(double d, double d2) {
        double d3 = d2 * Math.PI / 180.0;
        this.move(d * Math.cos(d3), -d * Math.sin(d3));
    }

    public GDimension getSize() {
        GRectangle gRectangle = this.getBounds();
        return new GDimension(gRectangle.getWidth(), gRectangle.getHeight());
    }

    public double getWidth() {
        return this.getBounds().getWidth();
    }

    public double getHeight() {
        return this.getBounds().getHeight();
    }

    public boolean contains(double d, double d2) {
        return this.getBounds().contains(GMath.round(d), GMath.round(d2));
    }

    public final boolean contains(GPoint gPoint) {
        return this.contains(gPoint.getX(), gPoint.getY());
    }

    public void sendToFront() {
        if (this.myParent == null) {
            return;
        }
        if (this.myParent instanceof GCanvas) {
            ((GCanvas)this.myParent).sendToFront(this);
        } else if (this.myParent instanceof GCompound) {
            ((GCompound)this.myParent).sendToFront(this);
        } else {
            try {
                Class<?> clazz = this.myParent.getClass();
                Class[] classArray = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] objectArray = new Object[]{this};
                Method method = clazz.getMethod("sendToFront", classArray);
                if (method != null) {
                    method.invoke((Object)this.myParent, objectArray);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void sendToBack() {
        if (this.myParent == null) {
            return;
        }
        if (this.myParent instanceof GCanvas) {
            ((GCanvas)this.myParent).sendToBack(this);
        } else if (this.myParent instanceof GCompound) {
            ((GCompound)this.myParent).sendToBack(this);
        } else {
            try {
                Class<?> clazz = this.myParent.getClass();
                Class[] classArray = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] objectArray = new Object[]{this};
                Method method = clazz.getMethod("sendToBack", classArray);
                if (method != null) {
                    method.invoke((Object)this.myParent, objectArray);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void sendForward() {
        if (this.myParent == null) {
            return;
        }
        if (this.myParent instanceof GCanvas) {
            ((GCanvas)this.myParent).sendForward(this);
        } else if (this.myParent instanceof GCompound) {
            ((GCompound)this.myParent).sendForward(this);
        } else {
            try {
                Class<?> clazz = this.myParent.getClass();
                Class[] classArray = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] objectArray = new Object[]{this};
                Method method = clazz.getMethod("sendForward", classArray);
                if (method != null) {
                    method.invoke((Object)this.myParent, objectArray);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void sendBackward() {
        if (this.myParent == null) {
            return;
        }
        if (this.myParent instanceof GCanvas) {
            ((GCanvas)this.myParent).sendBackward(this);
        } else if (this.myParent instanceof GCompound) {
            ((GCompound)this.myParent).sendBackward(this);
        } else {
            try {
                Class<?> clazz = this.myParent.getClass();
                Class[] classArray = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] objectArray = new Object[]{this};
                Method method = clazz.getMethod("sendBackward", classArray);
                if (method != null) {
                    method.invoke((Object)this.myParent, objectArray);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public Color getColor() {
        GObject gObject = this;
        while (gObject.color == null) {
            GContainer gContainer = gObject.getParent();
            if (gContainer instanceof GObject) {
                gObject = (GObject)((Object)gContainer);
                continue;
            }
            if (gContainer instanceof Component) {
                return ((Component)((Object)gContainer)).getForeground();
            }
            return Color.black;
        }
        return gObject.color;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
        this.repaint();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public String toString() {
        String string = this.getClass().getName();
        if (string.startsWith("acm.graphics.")) {
            string = string.substring("acm.graphics.".length());
        }
        return String.valueOf(string) + "[" + this.paramString() + "]";
    }

    public GContainer getParent() {
        return this.myParent;
    }

    public void pause(double d) {
        JTFTools.pause(d);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.mouseListenersEnabled = true;
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.mouseListenersEnabled = true;
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void fireActionEvent(String string) {
        this.fireActionEvent(new ActionEvent(this, 1001, string));
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        this.actionListener.actionPerformed(actionEvent);
    }

    protected void fireMouseListeners(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.mouseListener == null) break;
                this.mouseListener.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseReleased(mouseEvent);
                break;
            }
            case 500: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseClicked(mouseEvent);
                break;
            }
            case 505: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseExited(mouseEvent);
                break;
            }
            case 504: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseEntered(mouseEvent);
                break;
            }
            case 503: {
                if (this.mouseMotionListener == null) break;
                this.mouseMotionListener.mouseMoved(mouseEvent);
                break;
            }
            case 506: {
                if (this.mouseMotionListener == null) break;
                this.mouseMotionListener.mouseDragged(mouseEvent);
                break;
            }
        }
    }

    protected boolean areMouseListenersEnabled() {
        return this.mouseListenersEnabled;
    }

    protected void start() {
        this.start(null);
    }

    protected void start(String[] stringArray) {
        try {
            Class<?> clazz = Class.forName("acm.program.GraphicsProgram");
            Class<?> clazz2 = Class.forName("acm.graphics.GObject");
            Class[] classArray = new Class[]{clazz2, stringArray.getClass()};
            Object[] objectArray = new Object[]{this, stringArray};
            Method method = clazz.getMethod("startGraphicsProgram", classArray);
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    protected Color getObjectColor() {
        return this.color;
    }

    protected String paramString() {
        Object object;
        String string = "";
        if (this instanceof GResizable) {
            object = this.getBounds();
            string = String.valueOf(string) + "bounds=(" + ((GRectangle)object).getX() + ", " + ((GRectangle)object).getY() + ", " + ((GRectangle)object).getWidth() + ", " + ((GRectangle)object).getHeight() + ")";
        } else {
            object = this.getLocation();
            string = String.valueOf(string) + "location=(" + ((GPoint)object).getX() + ", " + ((GPoint)object).getY() + ")";
        }
        if (this.color != null) {
            string = String.valueOf(string) + ", color=" + this.colorName(this.color);
        }
        if (this instanceof GFillable) {
            string = String.valueOf(string) + ", filled=" + ((GFillable)((Object)this)).isFilled();
            object = ((GFillable)((Object)this)).getFillColor();
            if (object != null && object != this.color) {
                string = String.valueOf(string) + ", fillColor=" + this.colorName((Color)object);
            }
        }
        return string;
    }

    protected String colorName(Color color) {
        if (color.equals(Color.black)) {
            return "BLACK";
        }
        if (color.equals(Color.blue)) {
            return "BLUE";
        }
        if (color.equals(Color.cyan)) {
            return "CYAN";
        }
        if (color.equals(Color.darkGray)) {
            return "DARK_GRAY";
        }
        if (color.equals(Color.gray)) {
            return "GRAY";
        }
        if (color.equals(Color.green)) {
            return "GREEN";
        }
        if (color.equals(Color.lightGray)) {
            return "LIGHT_GRAY";
        }
        if (color.equals(Color.magenta)) {
            return "MAGENTA";
        }
        if (color.equals(Color.orange)) {
            return "ORANGE";
        }
        if (color.equals(Color.pink)) {
            return "PINK";
        }
        if (color.equals(Color.red)) {
            return "RED";
        }
        if (color.equals(Color.white)) {
            return "WHITE";
        }
        if (color.equals(Color.yellow)) {
            return "YELLOW";
        }
        return "0x" + Integer.toString(color.getRGB() & 0xFFFFFF, 16).toUpperCase();
    }

    protected void paintObject(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        Color color = graphics.getColor();
        if (this.color != null) {
            graphics.setColor(this.color);
        }
        this.paint(graphics);
        if (this.color != null) {
            graphics.setColor(color);
        }
    }

    protected void setParent(GContainer gContainer) {
        this.myParent = gContainer;
    }

    protected Component getComponent() {
        GContainer gContainer = this.getParent();
        while (gContainer instanceof GObject) {
            gContainer = ((GObject)((Object)gContainer)).getParent();
        }
        return (Component)((Object)gContainer);
    }

    protected void updateEnabledList() {
        Component component = this.getComponent();
        if (component instanceof GCanvas) {
            ((GCanvas)component).updateEnabledList();
        }
    }

    protected void repaint() {
        GContainer gContainer = this.getParent();
        while (gContainer instanceof GObject) {
            gContainer = ((GObject)((Object)gContainer)).getParent();
        }
        if (gContainer instanceof GCanvas) {
            ((GCanvas)gContainer).conditionalRepaint();
        }
    }
}

